Imports System.Data.SqlClient
Imports System.Data

Partial Class Register
    Inherits System.Web.UI.Page

    Protected Sub btnRegister_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnRegister.Click

        ' Takes the data from the form at "Register-account-signin.aspx" when the button is clicked and then inserts 
        ' this data to the table "Users" in the "Signindb" database. The password is encrypted with SHA1 and stored
        ' as an encrypted password in the table.

        SqlEx.Text = ""
        Try
            Dim passwordHash As String = FormsAuthentication.HashPasswordForStoringInConfigFile(txtPassword.Text, "SHA1")
            Dim ConnString As String = ConfigurationManager.ConnectionStrings("ConnectionString").ToString()
            Dim sql As String = "INSERT INTO Users (Username, Password, Company, OrgNumber, Contact, Attention, Adress, PostalCode, City, Country, RegisterDate, ExpireDate, Admin) VALUES (@Username, @Password, @Company, @OrgNumber, @Contact, @Attention, @Adress, @PostalCode, @City, @Country, @RegisterDate, @ExpireDate, @Admin)"

            ' The Using block is used to call dispose (close) automatically even if there are an exception.
            Using cn As New SqlConnection(ConnString), _
                  cmd As New SqlCommand(sql, cn)
                cmd.Parameters.Add("@Username", SqlDbType.VarChar, 80).Value = txtUserName.Text
                cmd.Parameters.Add("@Password", SqlDbType.VarChar, 40).Value = passwordHash
                cmd.Parameters.Add("@Company", SqlDbType.VarChar, 50).Value = txtCompanyName.Text
                cmd.Parameters.Add("@OrgNumber", SqlDbType.VarChar, 15).Value = txtOrganisationNumber.Text
                cmd.Parameters.Add("@Contact", SqlDbType.VarChar, 50).Value = txtContact.Text
                cmd.Parameters.Add("@Attention", SqlDbType.VarChar, 50).Value = txtAttention.Text
                cmd.Parameters.Add("@Adress", SqlDbType.VarChar, 50).Value = txtAdress.Text
                cmd.Parameters.Add("@PostalCode", SqlDbType.VarChar, 10).Value = txtPostalCode.Text
                cmd.Parameters.Add("@City", SqlDbType.VarChar, 50).Value = txtCity.Text
                cmd.Parameters.Add("@Country", SqlDbType.VarChar, 50).Value = txtCountry.Text
                cmd.Parameters.Add("@RegisterDate", SqlDbType.DateTime).Value = DateTime.Now.ToString()
                cmd.Parameters.Add("@ExpireDate", SqlDbType.DateTime).Value = DateTime.Now.AddYears(1).ToString()
                cmd.Parameters.Add("@Admin", SqlDbType.Bit).Value = 0

                cn.Open()
                cmd.ExecuteNonQuery()
                CurrentPanel.Visible = False
                ThankYouPanel.Visible = True

            End Using
        Catch ex As SqlException
            Select Case ex.Number
                Case 2601
                    SqlEx.Text = "* Given E-mail already exists"
                Case Else
                    Response.Write(ex.Message)
            End Select
        End Try
    End Sub
End Class
